<?php

namespace app\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Client extends Model 
{

    protected $table = 'client';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('ci', 'name', 'address', 'phone', 'mobile', 'email', 'notes', 'user_id');

    public function user()
    {
        return $this->belongsTo('app\Models\User', 'user_id');
    }

}